/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.admin.result;

import filenet.vw.api.VWFieldType;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.admin.result.VWAdminResultPane;
import filenet.vw.toolkit.admin.result.resources.VWResource;
import filenet.vw.toolkit.utils.VWAccessibilityHelper;
import filenet.vw.toolkit.utils.VWHelp;
import filenet.vw.toolkit.utils.VWKeyAdapter;
import filenet.vw.toolkit.utils.VWStringUtils;
import filenet.vw.toolkit.utils.dialog.VWModalDialog;
import filenet.vw.toolkit.utils.table.VWFieldsCellRenderer;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.text.ParseException;
import java.util.Date;
import java.util.NoSuchElementException;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public final class VWEditSimpleTypeFieldDialog
extends VWModalDialog
implements ActionListener,
DocumentListener {
    private VWAdminResultPane m_resultsPane = null;
    private Vector m_fieldVector = null;
    private String m_type = null;
    private Object m_object = null;
    private Object m_fieldValue = null;
    private String m_fieldName = null;
    private boolean m_bMultipleLines = false;
    private JLabel m_typeLabel = null;
    private JLabel m_typeUI = null;
    private JLabel m_valueLabel = null;
    private JTextField m_valueTextField = null;
    private JTextArea m_valueTextArea = null;
    private boolean m_bCanceled = true;
    JButton m_okButton = null;
    JButton m_cancelButton = null;
    JButton m_helpButton = null;

    public VWEditSimpleTypeFieldDialog(Frame parent, VWAdminResultPane resultsPane, String fieldName, Object fields, boolean bMultipleLines) throws NullPointerException {
        super(parent);
        this.m_resultsPane = resultsPane;
        this.m_fieldName = fieldName;
        this.m_bMultipleLines = bMultipleLines;
        if (fields == null) {
            throw new NullPointerException();
        }
        if (!(fields instanceof Vector)) {
            throw new NoSuchElementException();
        }
        this.initData(fields);
        this.setupLayout();
    }

    public Object getFieldArray() {
        return this.m_fieldValue;
    }

    public void addNotify() {
        super.addNotify();
        Font boldFont = null;
        Font font = null;
        font = this.getFont();
        if (font != null) {
            boldFont = new Font(font.getName(), 1, font.getSize());
        }
        if (boldFont != null) {
            this.m_typeLabel.setFont(boldFont);
            this.m_valueLabel.setFont(boldFont);
        }
    }

    public void windowClosing(WindowEvent event) {
        super.windowClosing(event);
        this.m_bCanceled = true;
    }

    public boolean isCanceled() {
        return this.m_bCanceled;
    }

    public void actionPerformed(ActionEvent event) {
        Object object = event.getSource();
        if (object == this.m_okButton) {
            this.onOkButton(event);
        } else if (object == this.m_cancelButton) {
            this.onCancelButton(event);
        } else if (object == this.m_valueTextField) {
            this.onOkButton(event);
        } else if (object == this.m_helpButton) {
            VWHelp.displayPage(VWHelp.Help_Process_Admin + "bpfah038.htm");
        }
    }

    public void changedUpdate(DocumentEvent e) {
    }

    public void insertUpdate(DocumentEvent e) {
        try {
            if (this.m_bMultipleLines) {
                if (e.getDocument() == this.m_valueTextArea.getDocument()) {
                    this.updateOkButtonState();
                }
            } else if (e.getDocument() == this.m_valueTextField.getDocument()) {
                this.updateOkButtonState();
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void removeUpdate(DocumentEvent e) {
        try {
            if (this.m_bMultipleLines) {
                if (e.getDocument() == this.m_valueTextArea.getDocument()) {
                    this.updateOkButtonState();
                }
            } else if (e.getDocument() == this.m_valueTextField.getDocument()) {
                this.updateOkButtonState();
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private void initData(Object fields) {
        int i;
        this.m_fieldVector = new Vector();
        for (i = 0; i < ((Vector)fields).size(); ++i) {
            this.m_fieldVector.addElement(((Vector)fields).elementAt(i));
        }
        for (i = 1; i < ((Vector)fields).size() && this.m_fieldVector.elementAt(0).equals(this.m_fieldVector.elementAt(i)); ++i) {
        }
        this.m_fieldValue = i == ((Vector)fields).size() ? this.m_fieldVector.elementAt(0) : VWResource.s_variousValues;
        this.initData();
    }

    private void initData() {
        block7: {
            Object obj = this.m_fieldVector.elementAt(0);
            try {
                if (obj instanceof Boolean) {
                    this.m_type = VWFieldType.getLocalizedString(4);
                    break block7;
                }
                if (obj instanceof Double) {
                    this.m_type = VWFieldType.getLocalizedString(8);
                    break block7;
                }
                if (obj instanceof Integer) {
                    this.m_type = VWFieldType.getLocalizedString(1);
                    break block7;
                }
                if (obj instanceof String) {
                    this.m_type = VWFieldType.getLocalizedString(2);
                    break block7;
                }
                if (obj instanceof Date) {
                    this.m_type = VWFieldType.getLocalizedString(16);
                    break block7;
                }
                throw new NoSuchElementException();
            }
            catch (Exception ex) {
                VWDebug.logException(ex);
            }
        }
    }

    private void setupLayout() {
        try {
            Container container = this.getContentPane();
            this.setResizable(true);
            Dimension dim = VWStringUtils.stringToDimension("445,255");
            if (dim == null) {
                dim = new Dimension(395, 226);
            }
            this.setSize(dim.width, dim.height);
            this.setVisible(false);
            this.setTitle(VWResource.s_editFieldsTitle);
            JPanel panel = this.addTextControls();
            if (panel != null) {
                this.getContentPane().add((Component)panel, "Center");
            }
            if ((panel = this.addButtonControls()) != null) {
                this.getContentPane().add((Component)panel, "Last");
            }
            this.m_okButton.addActionListener(this);
            this.m_cancelButton.addActionListener(this);
            this.m_helpButton.addActionListener(this);
            VWAccessibilityHelper.setAccessibility(this.m_okButton, this, VWResource.s_OK, VWResource.s_OK);
            this.m_okButton.addKeyListener(VWKeyAdapter.s_keyAdapter);
            VWAccessibilityHelper.setAccessibility(this.m_cancelButton, this, VWResource.s_cancel, VWResource.s_cancel);
            this.m_cancelButton.addKeyListener(VWKeyAdapter.s_keyAdapter);
            VWAccessibilityHelper.setAccessibility(this.m_helpButton, this, VWResource.s_help, VWResource.s_help);
            this.m_helpButton.addKeyListener(VWKeyAdapter.s_keyAdapter);
            if (VWStringUtils.compare(this.getValue(), VWResource.s_variousValues) == 0) {
                this.m_okButton.setEnabled(false);
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private void onOkButton(ActionEvent event) {
        try {
            this.m_bCanceled = false;
            String s = this.getValue();
            boolean b_ok = this.validateTextField(s, this.m_fieldVector.elementAt(0));
            if (b_ok) {
                this.updateFieldValue();
                this.setVisible(false);
            } else {
                if (this.m_bMultipleLines) {
                    this.m_valueTextArea.setText(VWFieldsCellRenderer.toString(this.m_fieldValue));
                } else {
                    this.m_valueTextField.setText(VWFieldsCellRenderer.toString(this.m_fieldValue));
                }
                if (VWStringUtils.compare(this.getValue(), VWResource.s_variousValues) == 0) {
                    this.m_okButton.setEnabled(false);
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private void onCancelButton(ActionEvent event) {
        try {
            this.m_bCanceled = true;
            this.setVisible(false);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void updateFieldValue() {
        String s = this.getValue();
        if (VWStringUtils.compare(s, VWResource.s_variousValues) == 0) return;
        Object obj = this.m_fieldVector.elementAt(0);
        if (obj instanceof Boolean) {
            try {
                if (VWStringUtils.compareIgnoreCase(s, VWResource.s_true) == 0 || VWStringUtils.compareIgnoreCase(s, "1") == 0) {
                    this.m_fieldValue = new Boolean(true);
                    return;
                }
                if (VWStringUtils.compareIgnoreCase(s, VWResource.s_false) != 0 && VWStringUtils.compareIgnoreCase(s, "0") != 0) return;
                this.m_fieldValue = new Boolean(false);
                return;
            }
            catch (Exception ex) {
                JOptionPane.showMessageDialog(null, VWResource.s_invalidBooleanFormat, VWResource.s_error, 1, null);
                return;
            }
        } else if (obj instanceof Integer) {
            try {
                this.m_fieldValue = new Integer(s);
                return;
            }
            catch (NumberFormatException ex) {
                JOptionPane.showMessageDialog(null, VWResource.s_invalidIntegerFormat, VWResource.s_error, 1, null);
                return;
            }
        } else if (obj instanceof Double) {
            try {
                double aDouble = VWFieldsCellRenderer.parse(s).doubleValue();
                this.m_fieldValue = new Double(aDouble);
                return;
            }
            catch (NumberFormatException ex) {
                JOptionPane.showMessageDialog(null, VWResource.s_invalidFloatFormat, VWResource.s_error, 1, null);
                return;
            }
            catch (ParseException ex) {
                JOptionPane.showMessageDialog(null, VWResource.s_invalidFloatFormat, VWResource.s_error, 1, null);
                return;
            }
        } else if (obj instanceof Date) {
            Date date = this.m_resultsPane.convertToDate(s);
            if (date == null) return;
            this.m_fieldValue = date;
            return;
        } else {
            this.m_fieldValue = obj instanceof String ? s : s;
        }
    }

    private JPanel addTextControls() {
        Object locString = null;
        JPanel panel = null;
        GridBagConstraints gbCons = null;
        Object label = null;
        try {
            panel = new JPanel();
            panel.setLayout(new GridBagLayout());
            gbCons = new GridBagConstraints();
            gbCons.insets = new Insets(10, 10, 5, 10);
            JLabel nameLabel = new JLabel(VWResource.s_name);
            VWAccessibilityHelper.setAccessibility(nameLabel, this, VWResource.s_name, VWResource.s_name);
            JLabel nameValue = new JLabel(this.m_fieldName);
            VWAccessibilityHelper.setAccessibility(nameValue, this, this.m_fieldName, this.m_fieldName);
            this.addRowControls(nameLabel, nameValue, panel, gbCons);
            this.m_typeLabel = new JLabel(VWResource.s_typeLabel);
            VWAccessibilityHelper.setAccessibility(this.m_typeLabel, this, VWResource.s_typeLabel, VWResource.s_typeLabel);
            this.m_typeUI = new JLabel(this.m_type);
            VWAccessibilityHelper.setAccessibility(this.m_typeUI, this, this.m_type, this.m_type);
            this.addRowControls(this.m_typeLabel, this.m_typeUI, panel, gbCons);
            this.m_valueLabel = new JLabel(VWResource.s_valueLabel);
            VWAccessibilityHelper.setAccessibility(this.m_valueLabel, this, VWResource.s_valueLabel, VWResource.s_valueLabel);
            if (this.m_bMultipleLines) {
                this.m_valueTextArea = new JTextArea();
                this.m_valueTextArea.getDocument().addDocumentListener(this);
                this.m_valueTextArea.setLineWrap(true);
                this.m_valueTextArea.setWrapStyleWord(false);
                this.m_valueTextArea.setRows(4);
                this.m_valueTextArea.setText(VWFieldsCellRenderer.toString(this.m_fieldValue));
                VWAccessibilityHelper.setAccessibility(this.m_valueTextArea, this, this.m_valueTextArea.getText(), this.m_valueTextArea.getText());
                this.addRowControls(this.m_valueLabel, new JScrollPane(this.m_valueTextArea), panel, gbCons);
            } else {
                this.m_valueTextField = new JTextField();
                this.m_valueTextField.getDocument().addDocumentListener(this);
                this.m_valueTextField.addActionListener(this);
                this.m_valueTextField.setText(VWFieldsCellRenderer.toString(this.m_fieldValue));
                VWAccessibilityHelper.setAccessibility(this.m_valueTextField, this, this.m_valueTextField.getText(), this.m_valueTextField.getText());
                this.addRowControls(this.m_valueLabel, this.m_valueTextField, panel, gbCons);
            }
            return panel;
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            return null;
        }
    }

    private void addRowControls(Component comp1, Component comp2, JPanel panel, GridBagConstraints gbCons) {
        try {
            gbCons.gridwidth = 1;
            gbCons.anchor = 21;
            gbCons.fill = 0;
            gbCons.weightx = 0.0;
            gbCons.weighty = 0.0;
            panel.add(comp1, gbCons);
            gbCons.gridwidth = 0;
            gbCons.fill = 2;
            gbCons.weightx = 1.0;
            panel.add(comp2, gbCons);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private JPanel addButtonControls() {
        JPanel panel = null;
        try {
            panel = new JPanel();
            panel.setLayout(new FlowLayout());
            this.m_okButton = new JButton(VWResource.s_OK);
            this.m_cancelButton = new JButton(VWResource.s_cancel);
            this.m_helpButton = new JButton(VWResource.s_help);
            panel.add(this.m_okButton);
            panel.add(this.m_cancelButton);
            panel.add(this.m_helpButton);
            return panel;
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            return null;
        }
    }

    private boolean validateTextField(String string, Object obj) {
        if (obj instanceof Integer) {
            try {
                Integer newValue = new Integer(string);
            }
            catch (NumberFormatException ex) {
                JOptionPane.showMessageDialog(null, VWResource.s_invalidIntegerFormat, VWResource.s_error, 1, null);
                return false;
            }
        } else if (obj instanceof Boolean) {
            try {
                if (VWStringUtils.compareIgnoreCase(string, VWResource.s_true) == 0 || VWStringUtils.compareIgnoreCase(string, "1") == 0) {
                    Boolean newValue = new Boolean(true);
                }
                if (VWStringUtils.compareIgnoreCase(string, VWResource.s_false) == 0 || VWStringUtils.compareIgnoreCase(string, "0") == 0) {
                    Boolean newValue = new Boolean(false);
                }
                JOptionPane.showMessageDialog(null, VWResource.s_invalidBooleanFormat, VWResource.s_error, 1, null);
                return false;
            }
            catch (NumberFormatException ex) {
                JOptionPane.showMessageDialog(null, VWResource.s_invalidBooleanFormat, VWResource.s_error, 1, null);
                return false;
            }
        } else if (obj instanceof Double) {
            try {
                double aDouble = VWFieldsCellRenderer.parse(string).doubleValue();
                Double newValue = new Double(aDouble);
            }
            catch (NumberFormatException ex) {
                JOptionPane.showMessageDialog(null, VWResource.s_invalidFloatFormat, VWResource.s_error, 1, null);
                return false;
            }
            catch (ParseException ex) {
                JOptionPane.showMessageDialog(null, VWResource.s_invalidFloatFormat, VWResource.s_error, 1, null);
                return false;
            }
        } else if (obj instanceof Date) {
            Date newValue = this.m_resultsPane.convertToDate(string);
            if (newValue == null) {
                return false;
            }
        } else if (obj instanceof String) {
            String newValue = string;
        } else {
            throw new NoSuchElementException();
        }
        return true;
    }

    private void updateOkButtonState() {
        boolean bEnable = true;
        if (this.m_okButton != null) {
            this.m_okButton.setEnabled(bEnable);
        }
    }

    private String getValue() {
        String s = null;
        s = this.m_bMultipleLines ? this.m_valueTextArea.getText() : this.m_valueTextField.getText();
        return s;
    }
}

